load([outputPath '\climateModel_led_manuscriptParams.mat']);
rmseRrmseMe;

vled = v;
led = bv;
ledsimrh = simrh;
ledmesrh = mesrh;
ledsimppm = simppm;
ledmesppm = mesppm;

load([outputPath '\climateModel_hps_manuscriptParams.mat']);
rmseRrmseMe;


vhps = v;
hps = bv;
hpssimrh = simrh;
hpsmesrh = mesrh;
hpssimppm = simppm;
hpsmesppm = mesppm;

figure;
subplot(4,2,1) 
hold on
title('T_{Air} HPS');
ylabel('T_{Air} (C)')
plot(vhps.tAir)
plot(hps.x.tAir)
axis([3.3e6 3.3e6+5*86400 14 32])
yticks([14 18.5 23 27.5 32])
grid
xtickNumToDate(bv,'dd/mm') 

subplot(4,2,3)
hold on
title('RH_{Air} HPS');
ylabel('RH_{Air} (%)')
plot(hpsmesrh)
plot(hpssimrh)
axis([3.3e6 3.3e6+5*86400 60 100])
grid
xtickNumToDate(bv,'dd/mm') 

subplot(4,2,5)
hold on
title('CO_{2,Air} HPS');
ylabel('CO_{2,Air} (ppm)')
xlabel('Date')
plot(hpsmesppm)
plot(hpssimppm)
axis([3.3e6 3.3e6+5*86400 300 2100])
yticks([300 750 1200 1650 2100])
grid
xtickNumToDate(bv,'dd/mm') 

subplot(4,2,2)
hold on
title('T_{Air} LED');
plot(vled.tAir)
plot(led.x.tAir)
legend('Measured','Simulated');
axis([3.3e6 3.3e6+5*86400 14 32])
yticks([14 18.5 23 27.5 32])
grid
xtickNumToDate(bv,'dd/mm') 

subplot(4,2,4)
hold on
title('RH_{Air} LED');
plot(ledmesrh)
plot(ledsimrh)
axis([3.3e6 3.3e6+5*86400 60 100])
grid
xtickNumToDate(bv,'dd/mm') 

subplot(4,2,6)
hold on
title('CO_{2,Air} LED');
xlabel('Date')
plot(ledmesppm)
plot(ledsimppm)
axis([3.3e6 3.3e6+5*86400 300 2100])
yticks([300 750 1200 1650 2100])
grid
xtickNumToDate(bv,'dd/mm') 

subplot(4,2,7)
hold on
title('Sun and lamps HPS');
xlabel('Date')
plot(hps.d.iGlob,'Color',[0.9290, 0.6940, 0.1250])
plot(hps.a.lampIn,'Color',[0.4940, 0.1840, 0.5560])
axis([3.3e6 3.3e6+5*86400 0 240])
yticks([0 60 120 180 240])
ylabel('Energy (W m^{-2})');
grid
xtickNumToDate(bv,'dd/mm') 

subplot(4,2,8)
hold on
title('Sun and lamps LED');
xlabel('Date')
plot(led.d.iGlob,'Color',[0.9290, 0.6940, 0.1250])
plot(led.a.lampIn,'Color',[0.4940, 0.1840, 0.5560])
axis([3.3e6 3.3e6+5*86400 0 240])
yticks([0 60 120 180 240])
legend('Sun radiation','Lamp input');
grid
xtickNumToDate(bv,'dd/mm') 